<?php

require_once 'Skooly.php';
require_once 'Hostpinacle.php';

class Skooly_init
{
    protected $ci;
    protected $apiKey;
    protected $senderID;
    protected $username;
    protected $password;
    protected $gateway;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('smssettings_m');

        $celcom_bind = [];
        $get_celcoms = $this->ci->smssettings_m->get_order_by_celcom();
        foreach ($get_celcoms as $get_celcom) {
            $celcom_bind[$get_celcom->field_names] = $get_celcom->field_values;
        }

        $this->apiKey = $celcom_bind['celcom_authKey'];
        $this->senderID = $celcom_bind['celcom_senderID'];
        $this->username = $celcom_bind['celcom_partnerID'];
        $this->password = $celcom_bind['celcom_password'];
        $this->gateway = $celcom_bind['celcom_gateway'];

        $this->initializeGateway();
    }

    private function initializeGateway()
    {
        if ($this->gateway === 'hostpinacle') {
            Hostpinacle::init($this->apiKey, $this->senderID, $this->username, $this->password);
        } elseif ($this->gateway === 'skooly') {
            Skooly::init($this->apiKey, $this->senderID, $this->username);
        } else {
            throw new Exception("Unsupported gateway: " . $this->gateway);
        }
    }
}
